/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.HostPortEvent;
import com.cisco.pt.ipc.events.HostPortEventListener;
import com.cisco.pt.ipc.events.IPCEventRegistry;
import com.cisco.pt.ipc.sim.port.HostPort;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostPortEventRegistry
extends IPCEventRegistry {
    protected Set<HostPortEventListener> globalListeners = new HashSet<HostPortEventListener>();
    protected Map<String, Set<HostPortEventListener>> specificObjectListeners = new HashMap<String, Set<HostPortEventListener>>();
    private static Log logger = LogFactory.getLog(HostPortEventRegistry.class);

    public HostPortEventRegistry(PacketTracerSession session) {
        super(session);
    }

    @Override
    public String getClassName() {
        return "HostPort";
    }

    @Override
    public void processEvent(IPCEventLTV event) throws Exception {
        String eventName = event.getEventName();
        HostPortEvent evt = null;
        if (eventName.equalsIgnoreCase("ipChanged")) {
            evt = new HostPortEvent.IpChanged(event);
        } else if (eventName.equalsIgnoreCase("ipv6LinkLocalChanged")) {
            evt = new HostPortEvent.Ipv6LinkLocalChanged(event);
        } else if (eventName.equalsIgnoreCase("ipv6AddressAdded")) {
            evt = new HostPortEvent.Ipv6AddressAdded(event);
        } else if (eventName.equalsIgnoreCase("ipv6AddressRemoved")) {
            evt = new HostPortEvent.Ipv6AddressRemoved(event);
        } else {
            logger.info((Object)("Unrecognized eventName for " + this.getClassName() + ": " + eventName));
            return;
        }
        for (HostPortEventListener listener : this.globalListeners) {
            listener.handleEvent(evt);
        }
        Set<HostPortEventListener> specificListeners = this.specificObjectListeners.get(evt.objectUUID.toString());
        if (specificListeners != null) {
            for (HostPortEventListener listener : specificListeners) {
                listener.handleEvent(evt);
            }
        }
    }

    public void addListenerFiltered(HostPortEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (events == null) {
                this.register("ipChanged");
                this.register("ipv6LinkLocalChanged");
                this.register("ipv6AddressAdded");
                this.register("ipv6AddressRemoved");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(events.get(i));
                }
            }
        }
        this.globalListeners.add(listener);
    }

    public void addSpecificListenerFiltered(HostPortEventListener listener, HostPort objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<HostPortEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners == null) {
            specificListeners = new HashSet<HostPortEventListener>();
            this.specificObjectListeners.put(uuidString, specificListeners);
            if (events == null) {
                this.register(uuid, "ipChanged");
                this.register(uuid, "ipv6LinkLocalChanged");
                this.register(uuid, "ipv6AddressAdded");
                this.register(uuid, "ipv6AddressRemoved");
            } else {
                for (int i = 0; i < events.size(); ++i) {
                    this.register(uuid, events.get(i));
                }
            }
        }
        specificListeners.add(listener);
    }

    public void removeListenerFiltered(HostPortEventListener listener, List<String> events) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (events == null) {
                this.deregister("ipChanged");
                this.deregister("ipv6LinkLocalChanged");
                this.deregister("ipv6AddressAdded");
                this.deregister("ipv6AddressRemoved");
            }
            this.globalListeners.remove(listener);
        }
    }

    public void removeSpecificListenerFiltered(HostPortEventListener listener, HostPort objClass, List<String> events) throws IOException {
        UUID uuid = objClass.getObjectUUID();
        String uuidString = uuid.toString();
        Set<HostPortEventListener> specificListeners = this.specificObjectListeners.get(uuidString);
        if (specificListeners != null && !specificListeners.isEmpty()) {
            this.deregister(uuid, "ipChanged");
            this.deregister(uuid, "ipv6LinkLocalChanged");
            this.deregister(uuid, "ipv6AddressAdded");
            this.deregister(uuid, "ipv6AddressRemoved");
            specificListeners.remove(listener);
        }
    }

    public void addListener(HostPortEventListener listener) throws IOException {
        this.addListenerFiltered(listener, null);
    }

    public void addListener(HostPortEventListener listener, HostPort objClass) throws IOException {
        this.addSpecificListenerFiltered(listener, objClass, null);
    }

    public void removeListener(HostPortEventListener listener) throws IOException {
        this.removeListenerFiltered(listener, null);
    }

    public void removeListener(HostPortEventListener listener, HostPort objClass) throws IOException {
        this.removeSpecificListenerFiltered(listener, objClass, null);
    }
}

